/*
 * Decompiled with CFR 0.152.
 */
package GeneralLibs;

import GeneralLibs.PartFileInputStream;
import java.io.IOException;

public class StringDataInputStream {
    PartFileInputStream m_InternalStream = null;
    String m_strFilePathName;
    int m_nSize;
    int m_nCurPos = -1;

    public StringDataInputStream(String strFilePathName) throws IOException {
        this.m_strFilePathName = strFilePathName;
        this.m_InternalStream = new PartFileInputStream(strFilePathName);
        this.m_nSize = this.m_InternalStream.available() / 2;
        this.m_nCurPos = 0;
    }

    public void reset() throws IOException {
        this.m_nCurPos = 0;
    }

    public void skip(int nChars) throws IOException {
        this.m_nCurPos += nChars;
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
        this.m_InternalStream.setPosition(this.m_nCurPos * 2);
    }

    public void setPosition(int nChars) throws IOException {
        this.m_nCurPos = nChars;
        if (this.m_nCurPos >= this.m_nSize || this.m_nCurPos < 0) {
            this.reset();
            throw new IOException("EOF reached");
        }
        this.m_InternalStream.setPosition(this.m_nCurPos * 2);
    }

    public void close() throws IOException {
    }

    public short readShort() throws IOException {
        short s = 0;
        int first = this.m_InternalStream.read();
        int second = this.m_InternalStream.read();
        ++this.m_nCurPos;
        s = (short)(first & 0xFF | second << 8 & 0xFF00);
        return s;
    }

    public int available() {
        return this.m_nSize - this.m_nCurPos;
    }

    public int indexOf(char ch) {
        int iIndex = -1;
        try {
            for (int i = this.m_nCurPos; i < this.m_nSize; ++i) {
                this.m_InternalStream.setPosition(i * 2);
                int first = this.m_InternalStream.read();
                int second = this.m_InternalStream.read();
                char c = (char)(first & 0xFF | second << 8 & 0xFF00);
                if (c != ch) continue;
                this.m_InternalStream.setPosition(this.m_nCurPos * 2);
                return i - this.m_nCurPos;
            }
            this.m_InternalStream.setPosition(this.m_nCurPos * 2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return -1;
        }
        return iIndex;
    }

    public String substring(int iStart, int iNoChars) {
        String str = new String("");
        int i = this.m_nCurPos + iStart;
        try {
            for (int j = 0; i < this.m_nSize && j < iNoChars; ++i, ++j) {
                this.m_InternalStream.setPosition(i * 2);
                int first = this.m_InternalStream.read();
                int second = this.m_InternalStream.read();
                char c = (char)(first & 0xFF | second << 8 & 0xFF00);
                str = str + c;
            }
            this.m_InternalStream.setPosition(this.m_nCurPos * 2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        return str;
    }

    public char charAt(int iIndex) {
        char c;
        int i = this.m_nCurPos + iIndex;
        try {
            this.m_InternalStream.setPosition(i * 2);
            int first = this.m_InternalStream.read();
            int second = this.m_InternalStream.read();
            c = (char)(first & 0xFF | second << 8 & 0xFF00);
            this.m_InternalStream.setPosition(this.m_nCurPos * 2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return '\uffff';
        }
        return c;
    }

    public int getPosition() {
        return this.m_nCurPos;
    }
}

