/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import DictPKG.HelpFunctions;

public class Dict
extends HelpFunctions {
    public static int COMPRESSED_ENTRIES = 16;
    public static int COMPRESSED_BITS = 5;
    public static int COMPRESSED_MASK = 31;
    public static int INCLUDE_LATIN = 1;
    public static int INCLUDE_SYMBOLS = 2;
    public static int INCLUDE_ARABIC = 4;
    public static int SKIP_CONTROL = 8;
    public static int CONVERT_2LOWER = 16;
    public static int EXCLUDE_DIAC = 32;
    public static int CLEAR_COUNTS = 256;
    public static int COUNT_FLAG = INCLUDE_ARABIC | INCLUDE_LATIN | INCLUDE_SYMBOLS | CONVERT_2LOWER;
    public static int INVALID_CHAR = 255;
    static int MAX_WORDS = 131072;
    static int CASH_SIZE = 20;
    static int WORDS_SURROUNDING_NUM = 5;
    static int MAX_PATH = 256;

    public static int iscntrl(int iTest) {
        if (iTest >= 0 && iTest >= 31 || iTest == 127) {
            return 1;
        }
        return 0;
    }

    public static int isalpha(int iTest) {
        if (iTest >= 97 && iTest <= 122) {
            return 1;
        }
        if (iTest >= 65 && iTest <= 90) {
            return 1;
        }
        return 0;
    }

    public static int StringNComapreNoCase(String arg1, String arg2, int Length) {
        if (arg1 == null) {
            return -1;
        }
        if (arg2 == null) {
            return 1;
        }
        String str1 = arg1.length() >= Length ? arg1.substring(0, Length) : arg1;
        String str2 = arg2.length() >= Length ? arg2.substring(0, Length) : arg2;
        str1 = str1.toLowerCase();
        str2 = str2.toLowerCase();
        if (str1.length() == str2.length()) {
            return str1.compareTo(str2);
        }
        int iMin = 0;
        iMin = str1.length() < str2.length() ? str1.length() : str2.length();
        for (int i = 0; i < iMin; ++i) {
            if (str1.charAt(i) < str2.charAt(i)) {
                return -1;
            }
            if (str1.charAt(i) <= str2.charAt(i)) continue;
            return 1;
        }
        return 0;
    }

    public static interface Compare {
        public int CompareMethod(Object var1, Object var2);
    }

    public static class LetterCountCompare
    implements Compare {
        public int CompareMethod(Object arg1, Object arg2) {
            LetterItem v1 = (LetterItem)arg1;
            LetterItem v2 = (LetterItem)arg2;
            if (Dict.iscntrl(v1.byInd) != 0 && v2.nCount != 0) {
                return 1;
            }
            if (Dict.iscntrl(v2.byInd) != 0 && v1.nCount != 0) {
                return -1;
            }
            if (v1.nCount == v2.nCount) {
                return 0;
            }
            if (v1.nCount < v2.nCount) {
                return 1;
            }
            return -1;
        }
    }

    public static class StringNComapreNoCase
    implements Compare {
        public int CompareMethod(Object arg1, Object arg2) {
            byte[] v1 = (byte[])arg1;
            byte[] v2 = (byte[])arg1;
            char[] chr1 = new char[v1.length];
            char[] chr2 = new char[v2.length];
            HelpFunctions.BytetoCharArray(chr1, 0, v1, 0, v1.length);
            HelpFunctions.BytetoCharArray(chr2, 0, v1, 0, v2.length);
            String str1 = new String(chr1);
            String str2 = new String(chr2);
            str1.toLowerCase();
            str2.toLowerCase();
            return str1.compareTo(str2);
        }
    }

    public static class WordCompareSize
    implements Compare {
        public int CompareMethod(Object arg1, Object arg2) {
            WordItem v1 = (WordItem)arg1;
            WordItem v2 = (WordItem)arg2;
            if (v1.nWordsSize == v2.nWordsSize) {
                return 0;
            }
            if (v1.nWordsSize < v2.nWordsSize) {
                return 1;
            }
            return -1;
        }
    }

    public static class QSort {
        private Compare comp;

        public QSort(Compare CompareMethod) {
            this.comp = CompareMethod;
        }

        public void sort(Object[] list) {
            this.quicksort(list, 0, list.length - 1);
        }

        public void sort(Object[] list, int start, int end) {
            this.quicksort(list, start, end - 1);
        }

        private void quicksort(Object[] list, int p, int r) {
            if (p < r) {
                int q = this.partition(list, p, r);
                if (q == r) {
                    --q;
                }
                this.quicksort(list, p, q);
                this.quicksort(list, q + 1, r);
            }
        }

        private int partition(Object[] list, int p, int r) {
            Object pivot = list[p];
            int lo = p;
            int hi = r;
            while (true) {
                if (this.comp.CompareMethod(list[hi], pivot) >= 0 && lo < hi) {
                    --hi;
                    continue;
                }
                while (this.comp.CompareMethod(list[lo], pivot) < 0 && lo < hi) {
                    ++lo;
                }
                if (lo >= hi) break;
                Object T = list[lo];
                list[lo] = list[hi];
                list[hi] = T;
            }
            return hi;
        }
    }

    public static class CompKey {
        byte charCount;
        byte nBits;
        byte nMask;
        byte nAMask;
        byte nCBits;
        byte nCMask;
        byte nShift;
        byte byKeysCount;
        byte byWordsCount;
        short[] keys = new short[256];
        short[] wordsOffsets = new short[256];
        byte[] words = new byte[2560];
        byte byMark;
        byte byMask;
        LetterItem[] liLetters;
    }

    public static class WordItem {
        byte[] pt;
        int nCount;
        int nWordSize;
        int nWordsSize;
    }

    public static class LetterItem {
        byte byInd;
        byte newID;
        byte[] fill = new byte[2];
        int nCount;
    }

    public static class LANGUAGEINFO {
        public String sDataFile;
        public String sIndexFile;
        public LANGUAGEINFO pNextLang;

        public LANGUAGEINFO(String strDataFile, String strIndexFile, LANGUAGEINFO pHeadNode) {
            this.sDataFile = strDataFile;
            this.sIndexFile = strIndexFile;
            this.pNextLang = pHeadNode;
        }
    }
}

