/*
 * Decompiled with CFR 0.152.
 */
package DictPKG;

import DictPKG.DICTDATAENTRY;
import DictPKG.Dict;
import DictPKG.Glossaries;
import DictPKG.Glossary;

public class DataMgr {
    protected Glossaries m_Glossaries = new Glossaries();
    protected Glossary[] m_pCurGlossary = null;
    protected DICTDATAENTRY[] m_pDDEntries = new DICTDATAENTRY[Dict.CASH_SIZE];
    protected int m_nCurSel = -1;
    protected int m_nCurSelInDB = -1;
    protected int m_nOldCurSel = -1;
    protected int m_nOldCurSelInDb = -1;
    protected int[] m_nCurCashSize = new int[1];
    protected String[] m_szPreSearchWord = new String[1];
    private boolean m_bLang = true;

    public DataMgr(boolean bLang) {
        this.m_nCurCashSize[0] = 0;
        this.m_szPreSearchWord[0] = "";
        this.m_bLang = bLang;
    }

    int EnumGlossaries(String lpPath, CENUMGLOSSARIESPROC pProc, Object lp) {
        int nLoop = 0;
        Dict.LANGUAGEINFO[] pNode = new Dict.LANGUAGEINFO[1];
        this.m_Glossaries.EnumDictFilesInDir(lpPath);
        pNode[0] = this.m_Glossaries.m_pLanguages;
        Dict.LANGUAGEINFO pToNode = pNode[0];
        while (pToNode != null && (pProc == null || pProc.ENUMGLOSSARIESPROC(pNode, lp))) {
            pToNode = pToNode.pNextLang;
            ++nLoop;
        }
        return nLoop;
    }

    int GetWordsCount() {
        if (this.m_pCurGlossary == null) {
            return 0;
        }
        return this.m_pCurGlossary[0].GetNumberOfWords();
    }

    boolean Init(int nSel) {
        String[] szDataFile = new String[1];
        String[] szIndexFile = new String[1];
        this.m_Glossaries.GetDatFile(nSel, szDataFile);
        this.m_Glossaries.GetIndexFile(nSel, szIndexFile);
        return this.Init(szDataFile, szIndexFile);
    }

    boolean Init(String[] pszDataFile, String[] pszIndexFile) {
        if (this.m_pCurGlossary != null) {
            this.m_pCurGlossary = null;
        }
        this.m_pCurGlossary = new Glossary[1];
        this.m_pCurGlossary[0] = new Glossary(this.m_bLang);
        boolean bRet = this.m_pCurGlossary[0].SetFileNames(pszDataFile[0], pszIndexFile[0]);
        if (bRet) {
            return bRet;
        }
        this.m_pCurGlossary = null;
        return bRet;
    }

    int SetCurSel(int nNewSel, int nSelInDb) {
        if (nSelInDb == -1 && this.m_nCurSel != -1) {
            nSelInDb = nNewSel - this.m_nCurSel;
            nSelInDb += this.m_nCurSelInDB;
        }
        this.m_nOldCurSel = this.m_nCurSel;
        this.m_nOldCurSelInDb = this.m_nCurSelInDB;
        this.m_nCurSel = nNewSel;
        this.m_nCurSelInDB = nSelInDb;
        return this.m_nOldCurSel;
    }

    boolean GetNext(DICTDATAENTRY[] ppDicEntry, int ippDicEntryIndex) {
        return this.GetAt(this.m_nCurSelInDB + 1, ppDicEntry, ippDicEntryIndex, true);
    }

    boolean GetPre(DICTDATAENTRY[] ppDicEntry, int ippDicEntryIndex) {
        return this.GetAt(this.m_nCurSelInDB - 1, ppDicEntry, ippDicEntryIndex, true);
    }

    boolean GetAt(int nWordIndex, DICTDATAENTRY[] ppDicEntry, int ippDicEntryIndex, boolean bSetSel) {
        int nGetFromDBStart = 0;
        int nGetFromDBSize = 0;
        int nCurSel = -1;
        if (this.m_pCurGlossary == null) {
            return false;
        }
        if (nWordIndex < 0) {
            nWordIndex = this.m_pCurGlossary[0].GetNumberOfWords() - 1;
        }
        if (nWordIndex >= this.m_pCurGlossary[0].GetNumberOfWords()) {
            nWordIndex = 0;
        }
        if (nWordIndex >= this.m_pCurGlossary[0].GetNumberOfWords() || nWordIndex < 0) {
            return false;
        }
        int nCashStartInDb = this.m_nCurSelInDB - this.m_nCurSel;
        if (this.m_nCurCashSize[0] != 0 && nWordIndex >= nCashStartInDb && nWordIndex < nCashStartInDb + this.m_nCurCashSize[0]) {
            nCurSel = nWordIndex - nCashStartInDb;
            if (bSetSel) {
                this.SetCurSel(nCurSel, nWordIndex);
            }
        } else {
            nGetFromDBStart = nWordIndex >= Dict.WORDS_SURROUNDING_NUM ? nWordIndex - Dict.WORDS_SURROUNDING_NUM : nWordIndex;
            nGetFromDBSize = Dict.CASH_SIZE;
            nCurSel = nWordIndex - nGetFromDBStart;
            if (nGetFromDBStart != -1 && nGetFromDBSize != -1 && nCurSel != -1) {
                this.m_nCurCashSize[0] = nGetFromDBSize;
                if (this.FillCash(nGetFromDBStart, 0, this.m_nCurCashSize)) {
                    this.SetCurSel(nCurSel, nWordIndex);
                }
            }
        }
        if (nCurSel != -1 && ppDicEntry != null) {
            ppDicEntry[ippDicEntryIndex] = this.m_pDDEntries[nCurSel];
        }
        return true;
    }

    void DummyFilling() {
        for (int i = 0; i < this.m_pDDEntries.length; ++i) {
            this.m_pDDEntries[i] = this.getDummyElement(i);
        }
    }

    private DICTDATAENTRY getDummyElement(int ii) {
        int i;
        DICTDATAENTRY _temp = new DICTDATAENTRY();
        _temp.nMeaningsCount = 2;
        _temp.szMeanings = new String[2];
        for (i = 0; i < _temp.szMeanings.length; ++i) {
            _temp.szMeanings[i] = "wwwww";
        }
        _temp.szWord = "Word : " + ii;
        _temp.szWordCode = new char[3];
        for (i = 0; i < _temp.szWordCode.length; ++i) {
            _temp.szWordCode[i] = 101;
        }
        return _temp;
    }

    boolean FillCash(int nDbIdx, int nAtCash, int[] pnSize) {
        System.out.println(nDbIdx);
        int nLoop = 0;
        System.out.println(nDbIdx);
        if (pnSize[0] <= Dict.CASH_SIZE) {
            System.out.println(nDbIdx);
            if (pnSize[0] > Dict.CASH_SIZE) {
                return false;
            }
            System.out.println(nDbIdx);
            if (this.m_pCurGlossary == null) {
                return false;
            }
            System.out.println(nDbIdx);
            if (nAtCash == -1) {
                nAtCash = 0;
            }
            System.out.println(nDbIdx);
            for (nLoop = nDbIdx; nLoop < pnSize[0] + nDbIdx && this.m_pCurGlossary[0].GetWordData(nLoop, this.m_pDDEntries, nAtCash); ++nLoop) {
                ++nAtCash;
            }
            pnSize[0] = nLoop - nDbIdx;
            return true;
        }
        return false;
    }

    int GetCurSel(int[] pnInCash) {
        if (pnInCash != null) {
            pnInCash[0] = this.m_nCurSel;
        }
        return this.m_nCurSelInDB;
    }

    boolean GetAt(String pszWord, DICTDATAENTRY[] ppDicEntry, int ippDicEntryIndex) {
        int[] inullObj;
        Glossary[] nullObj;
        boolean bRet = false;
        int nWordLen = 0;
        int[] nLastStart = new int[1];
        int[] nLastEnd = new int[1];
        int nSearchRes = -1;
        boolean bInCash = false;
        if (pszWord == null || (nWordLen = pszWord.length()) == 0) {
            this.m_szPreSearchWord[0] = "";
            return true;
        }
        if (this.m_pDDEntries[0] != null && this.m_pDDEntries[0].szWord != "" && Dict.StringNComapreNoCase(pszWord, this.m_pDDEntries[0].szWord, nWordLen) >= 0 && this.m_pDDEntries[Dict.CASH_SIZE - 1] != null && this.m_pDDEntries[Dict.CASH_SIZE - 1].szWord != "" && Dict.StringNComapreNoCase(pszWord, this.m_pDDEntries[Dict.CASH_SIZE - 1].szWord, nWordLen) <= 0 && (nSearchRes = this.BSearchWord(pszWord, nullObj = null, this.m_pDDEntries, 0, Dict.CASH_SIZE - 1, nLastStart, nLastEnd, inullObj = null)) != -1) {
            DICTDATAENTRY[] pDDE;
            int nCashStartInDB;
            bInCash = true;
            if ((nSearchRes = this.FindFirstItem(pszWord, null, this.m_pDDEntries, 0, nSearchRes)) == 0 && this.m_pCurGlossary[0].GetWordData((nCashStartInDB = this.m_nCurSelInDB - this.m_nCurSel) - 1, pDDE = new DICTDATAENTRY[1], 0) && (nCashStartInDB = Dict.StringNComapreNoCase(pszWord, pDDE[0].szWord, nWordLen)) <= 0) {
                nSearchRes = -1;
            }
            if (nSearchRes != -1) {
                this.SetCurSel(nSearchRes, -1);
            }
        }
        if (nSearchRes == -1) {
            int nChStart = 0;
            int nChEnd = 0;
            int nPreSearchWordLen = this.m_szPreSearchWord.length;
            nChStart = this.m_pCurGlossary[0].GetCharIndex(pszWord.charAt(0));
            if (nChStart == -1) {
                nChStart = 0;
            }
            if (nChStart != -1) {
                if (nWordLen == 1 && this.m_pCurGlossary[0].GetCharIndex(pszWord.charAt(0)) != -1) {
                    nSearchRes = nChStart;
                } else {
                    nChEnd = this.m_szPreSearchWord != null && nPreSearchWordLen == nWordLen + 1 && Dict.StringNComapreNoCase(this.m_szPreSearchWord[0], pszWord, nWordLen) == 0 ? this.m_nCurSelInDB : this.m_pCurGlossary[0].GetNextCharIndex(pszWord.charAt(0));
                    if (nChEnd == -1) {
                        nChEnd = this.m_pCurGlossary[0].GetNumberOfWords();
                    }
                    if (nChEnd != 0 && nChEnd != -1) {
                        nSearchRes = this.BSearchWord(pszWord, this.m_pCurGlossary, null, nChStart, nChEnd, nLastStart, nLastEnd, null);
                        nSearchRes = this.FindFirstItem(pszWord, this.m_pCurGlossary, null, nChStart, nSearchRes);
                    }
                }
                if (nSearchRes != -1) {
                    this.m_nCurCashSize[0] = Dict.CASH_SIZE;
                    if (nSearchRes >= Dict.WORDS_SURROUNDING_NUM) {
                        this.FillCash(nSearchRes - Dict.WORDS_SURROUNDING_NUM, 0, this.m_nCurCashSize);
                        this.SetCurSel(Dict.WORDS_SURROUNDING_NUM, nSearchRes);
                    } else {
                        this.FillCash(nSearchRes, 0, this.m_nCurCashSize);
                        this.SetCurSel(0, nSearchRes);
                    }
                }
            }
        }
        if (nSearchRes != -1 && this.m_nCurSel != -1) {
            if (ppDicEntry != null) {
                ppDicEntry[ippDicEntryIndex] = this.m_pDDEntries[this.m_nCurSel];
            }
            int nPreSearchWordLen = nWordLen < Dict.MAX_PATH ? nWordLen : Dict.MAX_PATH;
            this.m_szPreSearchWord[0] = pszWord.substring(0, nPreSearchWordLen);
            bRet = true;
        }
        return bRet;
    }

    int FindFirstItem(String pszWord, Glossary[] pGloss, DICTDATAENTRY[] pDicEntries, int nStart, int nEnd) {
        int nWordLen = 0;
        int nCmpRes = 0;
        int nLoop = 0;
        nWordLen = pszWord.length();
        if (pGloss != null) {
            DICTDATAENTRY[] pEntry;
            boolean bRes;
            for (nLoop = nEnd - 1; !(nLoop <= nStart || pGloss != null && (bRes = pGloss[0].GetWordData(nLoop, pEntry = new DICTDATAENTRY[1], 0)) && (nCmpRes = Dict.StringNComapreNoCase(pszWord, pEntry[0].szWord, nWordLen)) != 0); nLoop -= 20) {
            }
            for (int i = nLoop; i < nLoop + 21; ++i) {
                DICTDATAENTRY[] pEntry2;
                boolean bRes2;
                if (pGloss == null || !(bRes2 = pGloss[0].GetWordData(i, pEntry2 = new DICTDATAENTRY[1], 0)) || (nCmpRes = Dict.StringNComapreNoCase(pszWord, pEntry2[0].szWord, nWordLen)) != 0) continue;
                return i;
            }
            if (nLoop < 0) {
                return -1;
            }
            return nLoop;
        }
        for (nLoop = nEnd - 1; nLoop >= nStart && (pDicEntries == null || (nCmpRes = Dict.StringNComapreNoCase(pszWord, pDicEntries[nLoop].szWord, nWordLen)) == 0); --nLoop) {
        }
        return nLoop + 1;
    }

    int BSearchWord(String pszWord, Glossary[] pGloss, DICTDATAENTRY[] pDicEntries, int nStart, int nEnd, int[] pnLastStart, int[] pnLastEnd, int[] pnIterations) {
        int nMid = 0;
        int nWordLen = 0;
        int nCmpRes = 0;
        int nFound = -1;
        nWordLen = pszWord.length();
        if (pnIterations != null) {
            pnIterations[0] = 0;
        }
        while (nStart <= nEnd) {
            nMid = (nEnd + nStart) / 2;
            if (pnIterations != null) {
                pnIterations[0] = pnIterations[0] + 1;
            }
            if (pGloss != null) {
                DICTDATAENTRY[] pEntry = new DICTDATAENTRY[1];
                boolean bRes = pGloss[0].GetWordData(nMid, pEntry, 0);
                if (bRes) {
                    nCmpRes = Dict.StringNComapreNoCase(pszWord, pEntry[0].szWord, nWordLen);
                }
            } else if (pDicEntries != null) {
                nCmpRes = Dict.StringNComapreNoCase(pszWord, pDicEntries[nMid].szWord, nWordLen);
            }
            if (nCmpRes == 0) {
                nFound = nMid;
                break;
            }
            if (nCmpRes > 0) {
                nStart = nMid + 1;
                continue;
            }
            if (nCmpRes >= 0) continue;
            nEnd = nMid - 1;
        }
        if (nFound != 0 && pnLastStart != null && pnLastEnd != null) {
            pnLastStart[0] = nStart;
            pnLastEnd[0] = nEnd;
        }
        return nFound;
    }

    void FreeCash(int nFrom, int nSize) {
        int nLoop = 0;
        if (this.m_pCurGlossary == null) {
            return;
        }
        if (nSize <= Dict.CASH_SIZE) {
            if (nSize > Dict.CASH_SIZE - nFrom) {
                nSize = Dict.CASH_SIZE - nFrom;
            }
            for (nLoop = nFrom; nLoop < nSize + nFrom; ++nLoop) {
                this.m_pCurGlossary[0].FreeWordData(this.m_pDDEntries, nLoop);
            }
        }
    }

    public class CENUMGLOSSARIESPROC
    implements IENUMGLOSSARIESPROC {
        public boolean ENUMGLOSSARIESPROC(Dict.LANGUAGEINFO[] pLang, Object LPARAM) {
            return true;
        }
    }

    public static interface IENUMGLOSSARIESPROC {
        public boolean ENUMGLOSSARIESPROC(Dict.LANGUAGEINFO[] var1, Object var2);
    }
}

